// Funzione catalogo messier

function messier_cat(catnum,name,cons,ra_h,ra_m,ra_s,de_g,de_p,de_ss,mpra_h,mpra_m,mpra_s, mpde_g,mpde_p,mpde_ss,ra_h1,ra_m1,ra_s1,sgn_dec,de_g1,de_p1,de_ss1,sgn_h,h_g,h_p,h_ss,a_g,a_p,a_ss,sgn_e,laec_g,laec_p,laec_ss,loec_g,loec_p,loec_ss,mg,dist_al,type,dimapp,dimreal,sorg_cat,meri_cat,tram_cat,altezza,azimut) 
{
  	this.catnum = catnum;
  	this.name = name;
  	this.cons = cons;

  	this.ra_h = ra_h;
	this.ra_m = ra_m;
	this.ra_s = ra_s;

  	this.de_g = de_g;
	this.de_p = de_p;
	this.de_ss = de_ss;
	
  	this.mpra_h = mpra_h;
	this.mpra_m = mpra_m;
	this.mpra_s = mpra_s;

  	this.mpde_g = mpde_g;
	this.mpde_p = mpde_p;
	this.mpde_ss = mpde_ss;

  	this.ra_h1 = ra_h1;
	this.ra_m1 = ra_m1;
	this.ra_s1 = ra_s1;

	this.sgn_dec = sgn_dec;
  	this.de_g1 = de_g1;
	this.de_p1 = de_p1;
	this.de_ss1 = de_ss1;
	
	this.sgn_h = sgn_h;
  	this.h_g = h_g;
	this.h_p = h_p;
	this.h_ss = h_ss;
	
  	this.a_g = a_g;
	this.a_p = a_p;
	this.a_ss = a_ss;
	
	this.sgn_e = sgn_e;
  	this.laec_g = laec_g;
	this.laec_p = laec_p;
	this.laec_ss = laec_ss;
	
  	this.loec_g = loec_g;
	this.loec_p = loec_p;
	this.loec_ss = loec_ss;
	
  	this.mg = mg;
	this.dist_al = dist_al;
  	this.type = type;
  	this.dimapp = dimapp;
  	this.dimreal = dimreal;

	this.sorg_cat = sorg_cat; 
	this.meri_cat = meri_cat; 
	this.tram_cat = tram_cat; 
	
	this.altezza = altezza; 
	this.azimut = azimut; 
	
	
}

// Funzione pulsante "stelle brillanti" 

function messier_graph(obj)
{  
	// Firma digitale 
	if (obj.FIRMA.value == "     Agostino Frosini  -  Javascript Software 2020  -") 
		{
		
// DATABASE CATALOGO STELLARE ---------------------------------------------------- 
		var messier = new Array(
  		
		// Catalogo Messier 
		new messier_cat("M1","Nebulosa del Granchio","Toro",5,34,31.94,22,0,52.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","6200 AL","Nebulosa diffusa","6x4 arcmin","10.8 AL","---","---","---"),
		new messier_cat("M2","Ammasso globulare","Acquario",21,33,27.02,-0,-49,-23.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.46","38000 AL","Ammasso globulare","2.1 arcmin","23.1 AL","---","---","---"),
		new messier_cat("M3","Ammasso globulare","Cani da caccia",13,42,11.62,28,22,38.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.19","33000 AL","Ammasso globulare","4.6 arcmin","44.7 AL","---","---","---"),
		new messier_cat("M4","Ammasso globulare","Scorpione",16,23,35.23,-26,-31,-32.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.7","7200 AL","Ammasso globulare","8.7 arcmin","18.1 AL","---","---","---"),
		new messier_cat("M5","Ammasso globulare","Serpente",15,18,33.23,2,4,51.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.65","24000 AL","Ammasso globulare","3.5 arcmin","25.1 AL","---","---","---"),
		new messier_cat("M6","Ammasso aperto","Scorpione",17,40,19.93,-32,-15,-10.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.19","1600 AL","Ammasso aperto","20 arcmin","9.2 AL","---","---","---"),
		new messier_cat("M7","Ammasso aperto","Scorpione",17,53,51.13,-34,-47,-34.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.29","980 AL","Ammasso aperto","80 arcmin","22.8 AL","---","---","---"),
		new messier_cat("M8","Nebulosa Laguna","Saggittario",18,03,36.96,-24,-22,-40.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.0","4300 AL","Nebulosa diffusa","90x40 arcmin","113.6 AL","---","---","---"),
		new messier_cat("M9","Ammasso globulare","Ofiuco",17,19,11.78,-18,-30,-50.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.71","26000 AL","Ammasso globulare","1.9 arcmin","14.4 AL","---","---","---"),
		new messier_cat("M10","Ammasso globulare","Ofiuco",16,57,09.05,-4,-6,-1.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.59","14000 AL","Ammasso globulare","3.9 arcmin","16.3 AL","---","---","---"),
		new messier_cat("M11","Ammasso dell'anatra selvaggia","Scudo",18,51,5.05,-6,-16,-12.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.8","6100 AL","Ammasso aperto","32 arcmin","57 AL","---","---","---"),
		new messier_cat("M12","Ammasso globulare Pallina di gomma","Ofiuco",16,47,14.18,-1,-56,-54.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.69","16000 AL","Ammasso globulare","3.5 arcmin","16.1 AL","---","---","---"),
		new messier_cat("M13","Ammasso globulare Ercole","Ercole",16,41,41.64,36,27,40.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.78","23000 AL","Ammasso globulare","3.4 arcmin","22.8 AL","---","---","---"),
		new messier_cat("M14","Ammasso globulare","Ofiuco",17,37,36.16,-3,-14,-45.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.59","30000 AL","Ammasso globulare","2.6 arcmin","22.9 AL","---","---","---"),
		new messier_cat("M15","Ammasso globulare","Pegaso",21,29,58.33,12,10,1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.19","34000 AL","Ammasso globulare","2.0 arcmin","19.7 AL","---","---","---"),
		new messier_cat("M16","Nebulosa Aquila","Serpente",18,18,48.01,-13,-48,-25.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.4","5700 AL","Nebulosa diffusa","35x28 arcmin","58.1 AL","---","---","---"),
		new messier_cat("M17","Nebulosa Omega","Saggittario",18,20,47.04,-16,-10,-19.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.0","4200 AL","Nebulosa diffusa","46x37 arcmin","56.7 AL","---","---","---"),
		new messier_cat("M18","Ammasso aperto Cigno nero","Saggittario",19,19,58.08,-17,-6,-7.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.0","4200 AL","Ammasso aperto","5 arcmin","6.1 AL","---","---","---"),
		new messier_cat("M19","Ammasso globulare","Ofiuco",17,2,37.69,-26,-16,-4.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.76","29000 AL","Ammasso globulare","2.6 arcmin","22 AL","---","---","---"),
		new messier_cat("M20","Nebulosa Trifida","Saggittario",18,2,42.0,-22,-58,-19.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.3","5200 AL","Nebulosa diffusa","29x27 arcmin","43.9 AL","---","---","---"),
		new messier_cat("M21","Ammasso aperto Croce di Webb","Saggittario",18,4,12.96,-22,-29,-24.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.9","3900 AL","Ammasso aperto","14.0 arcmin","16 AL","---","---","---"),
		new messier_cat("M22","Ammasso globulare del Gran Saggittario","Saggittario",18,36,23.95,-23,-54,-17.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.09","10000 AL","Ammasso globulare","6.7 arcmin","20.4 AL","---","---","---"),
		new messier_cat("M23","Ammasso aperto","Saggittario",17,57,4.08,-18,-59,-6.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.5","2000 AL","Ammasso aperto","29 arcmin","17.3 AL","---","---","---"),
		new messier_cat("M24","Ammasso aperto delle Caustiche","Saggittario",18,16,48.01,-18,-33,-0.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.6","12000 AL","Ammasso aperto","6 arcmin","20.5 AL","---","---","---"),
		new messier_cat("M25","Ammasso aperto","Saggittario",18,31,47.05,-19,-7,-1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.5","2000 AL","Ammasso aperto","29 arcmin","17.1 AL","---","---","---"),
		new messier_cat("M26","Ammasso aperto","Scudo",18,45,18.01,-9,-22,-58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.0","5200 AL","Ammasso aperto","7.0 arcmin","10.6 AL","---","---","---"),
		new messier_cat("M27","Nebulosa Manubrio","Volpetta",19,59,36.39,22,43,15.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.09","1700 AL","Nebulosa planetaria","8.0x5.7 arcmin","4.0 AL","---","---","---"),
		new messier_cat("M28","Ammasso globulare","Saggittario",18,24,32.90,-24,-52,-11.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.78","18000 AL","Ammasso globulare","3.9 arcmin","20.5 AL","---","---","---"),
		new messier_cat("M29","Ammasso aperto Torre di raffreddamento","Cigno",20,23,55.92,38,31,22.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.59","3700 AL","Ammasso aperto","10.0 arcmin","10.9 AL","---","---","---"),
		new messier_cat("M30","Ammasso globulare Medusa","Capricorno",21,40,22.13,-23,-10,-47.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.19","26000 AL","Ammasso globulare","2.1 arcmin","15.9 AL","---","---","---"),
		new messier_cat("M31","Galassia di Andromeda","Andromeda",0,42,44.33,41,16,7.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.40","2500000 AL","Galassia a spirale","189.1x61.7 arcmin","139600 AL","---","---","---"),
		new messier_cat("M32","Galassia","Andromeda",0,42,41.83,40,51,54.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.10","2500000 AL","Galassia ellittica","8.5x6.5 arcmin","6200 AL","---","---","---"),
		new messier_cat("M33","Galassia Girandola","Triangolo",1,33,50.91,30,39,35.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.69","2800000 AL","Galassia a spirale","68.7x41.6 arcmin","56100 AL","---","---","---"),
		new messier_cat("M34","Ammasso aperto","Perseo",2,42,5.04,42,45,43.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.19","1600 AL","Ammasso aperto","35 arcmin","16.6 AL","---","---","---"),
		new messier_cat("M35","Ammasso aperto","Gemelli",6,8,54,24,19,58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.09","3000 AL","Ammasso aperto","40 arcmin","34.6 AL","---","---","---"),
		new messier_cat("M36","Ammasso aperto Girandola","Auriga",5,36,18,24,8,24,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.0","4300 AL","Ammasso aperto","10 arcmin","12.6 AL","---","---","---"),
		new messier_cat("M37","Ammasso aperto","Auriga",5,52,18,32,33,10.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.59","4500 AL","Ammasso aperto","14 arcmin","18.4 AL","---","---","---"),
		new messier_cat("M38","Ammasso aperto Stella Marina","Auriga",5,28,42.96,35,51,18,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.40","4600 AL","Ammasso aperto","20 arcmin","26.6 AL","---","---","---"),
		new messier_cat("M39","Ammasso aperto","Cigno",21,31,48.01,48,25,58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.59","1100 AL","Ammasso aperto","29 arcmin","9 AL","---","---","---"),
		new messier_cat("M40","Stella doppia Winnecke 4","Orsa Maggiore",12,22,12.54,58,4,58.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.64","510 AL","Stella doppia","1.7 arcmin","0.2 AL","---","---","---"),
		new messier_cat("M41","Ammasso aperto Piccolo Alveare","Cane Maggiore",6,45,0.96,-20,-45,-25.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.50","2300 AL","Ammasso aperto","39 arcmin","26.3 AL","---","---","---"),
		new messier_cat("M42","Nebulosa di Orione","Orione",5,35,17.31,-5,-23,-28.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.00","1400 AL","Nebulosa diffusa","85.0x60.0 arcmin","34.7 AL","---","---","---"),
		new messier_cat("M43","Nebulosa di Mairan","Orione",5,35,30.96,-5,-16.0,-12.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.00","1800 AL","Nebulosa diffusa","20.0x15.0 arcmin","10.2 AL","---","---","---"),
		new messier_cat("M44","Ammasso aperto Presepe","Cancro",8,40,24.01,19,40,1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.09","610 AL","Ammasso aperto","70 arcmin","12.4 AL","---","---","---"),
		new messier_cat("M45","Ammasso aperto Pleiadi","Toro",3,47,0,24,7,1.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.50","430 AL","Ammasso aperto","120 arcmin","15.1 AL","---","---","---"),
		new messier_cat("M46","Ammasso aperto","Poppa",7,41,46.08,-14,-48,-36,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.09","4900 AL","Ammasso aperto","20 arcmin","28.7 AL","---","---","---"),
		new messier_cat("M47","Ammasso aperto","Poppa",7,36,35.05,-14,-28,-58.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.40","1600 AL","Ammasso aperto","25 arcmin","11.6 AL","---","---","---"),
		new messier_cat("M48","Ammasso aperto","Idra",8,13,42.97,-5,-45,-0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.8","2500 AL","Ammasso aperto","30 arcmin","21.9 AL","---","---","---"),
		new messier_cat("M49","Galassia","Vergine",12,29,46.8,8,0,1.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","55000000 AL","Galassia ellittica","10.2x8.3 arcmin","162800 AL","---","---","---"),
		new messier_cat("M50","Ammasso aperto Cuore","Unicorno",7,2,47.5,-8,-20,-16.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.90","3100 AL","Ammasso aperto","14 arcmin","12.6 AL","---","---","---"),
		
		
		
		new messier_cat("M51","Galassia Vortice","Cani da caccia",13,29,52.70,47,11,42.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","27M AL","Galassia a spirale","11.2 x 6.9 arcmin","89.2K AL","---","---","---"),
		new messier_cat("M52","Ammasso aperto sale e pepe","Cassiopea",23,24,48.01,61,35,34.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.9","4.6K AL","Ammasso aperto","15 arcmin","19.9 AL","---","---","---"),
		new messier_cat("M53","Ammasso globulare","Chioma di Berenice",13,12,55.25,18,10,5.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.61","58K AL","Ammasso globulare","2.6 arcmin","44.4 AL","---","---","---"),
		new messier_cat("M54","Ammasso globulare","Saggittario",18,55,3.33,-30,-28,-47.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.59","86K AL","Ammasso globulare","1.6 arcmin","41.1 AL","---","---","---"),
		new messier_cat("M55","Ammasso globulare Stella rosa d'estate","Saggittario",19,39,59.7,-30,-57,-53.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.32","18K AL","Ammasso globulare","5.7 arcmin","29 AL","---","---","---"),
		new messier_cat("M56","Ammasso globulare","Lira",19,16,35.58,30,11,0.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.27","31K AL","Ammasso globulare","2.2 arcmin","19.6 AL","---","---","---"),
		new messier_cat("M57","Nebulosa Anello","Lira",18,53,35.08,33,1,45,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.8","1.4K AL","Nebulosa planetaria","1.4 x 1.1 arcmin","0.6 AL","---","---","---"),
		new messier_cat("M58","Galassia","Vergine",12,37,43.60,11,49,5.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.69","62M AL","Galassia a spirale","6 x 4.8 arcmin","108K AL","---","---","---"),
		new messier_cat("M59","Galassia","Vergine",12,42,2.33,11,38,49,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.6","48M AL","Galassia ellittica","5.4 x 3.7 arcmin","76.1K AL","---","---","---"),
		new messier_cat("M60","Galassia","Vergine",12,43,40.01,11,33,9.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.8","56M AL","Galassia ellittica","7.6 x 6.2 arcmin","124.2K AL","---","---","---"),
		new messier_cat("M61","Galassia Gonfiabile","Vergine",12,21,54.95,4,28,24.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.69","60M AL","Galassia a spirale","6.5 x 5.9 arcmin","113.8K AL","---","---","---"),
		new messier_cat("M62","Ammasso globulare Tremolante","Ofiuco",17,1,12.60,-30,-6,-44.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.44","22K AL","Ammasso globulare","1.8 arcmin","11.8 AL","---","---","---"),
		new messier_cat("M63","Galassia Girasole","Cani da caccia",13,15,49.33,42,1,45.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.60","34M AL","Galassia a spirale","12.6 x 7.2 arcmin","123.5K AL","---","---","---"),
		new messier_cat("M64","Galassia Occhio Nero","Chioma di Berenice",12,56,43.70,21,40,57.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.5","24M AL","Galassia a spirale","10 x 5.4 arcmin","70K AL","---","---","---"),
		new messier_cat("M65","Galassia","Leone",11,18,55.96,13,5,32.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.3","39M AL","Galassia a spirale","9.8 x 2.9 arcmin","111.3K AL","---","---","---"),
		new messier_cat("M66","Galassia","Leone",11,20,15.03,12,59,28.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","37M AL","Galassia a spirale","9.1 x 4.1 arcmin","96.9K AL","---","---","---"),
		new messier_cat("M67","Ammasso aperto Occhio d'oro","Cancro",8,51,18.0,11,48,0.0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.9","3K AL","Ammasso aperto","25 arcmin","21.5 AL","---","---","---"),
		new messier_cat("M68","Ammasso globulare","Idra",12,39,27.98,-26,-44,-38.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.84","34K AL","Ammasso globulare","3 arcmin","29.5 AL","---","---","---"),
		new messier_cat("M69","Ammasso globulare","Saggittario",18,31,23.10,-32,-20,-53.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.63","29K AL","Ammasso globulare","1.7 arcmin","14.1 AL","---","---","---"),
		new messier_cat("M70","Ammasso globulare","Saggittario",18,43,12.76,-32,-17,-31.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.86","29K AL","Ammasso globulare","1.4 arcmin","12.1 AL","---","---","---"),
		new messier_cat("M71","Ammasso globulare Squatina","Saggittario",19,53,46.49,18,46,45.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.18","13K AL","Ammasso globulare","3.3 arcmin","12.7 AL","---","---","---"),
		new messier_cat("M72","Ammasso globulare","Acquario",20,53,27.71,-12,-32,-14.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.27","55K AL","Ammasso globulare","1.9 arcmin","30.1 AL","---","---","---"),
		new messier_cat("M73","Ammasso aperto","Acquario",20,59,0.01,-12,-37,-48,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","2K AL","Ammasso aperto","9 arcmin","5.3 AL","---","---","---"),
		new messier_cat("M74","Galassia Fantasma","Pesci",1,36,41.78,15,47,0.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.39","28M AL","Galassia a spirale","10.5 x 9.5 arcmin","85.6K AL","---","---","---"),
		new messier_cat("M75","Ammasso globulare","Saggittario",20,6,4.85,-21,-55,-20.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.52","68K AL","Ammasso globulare","0.9 arcmin","18.2 AL","---","---","---"),
		new messier_cat("M76","Nebulosa Manubrio","Perseo",1,42,19.95,5,34,31.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10.1","6.4K AL","Nebulosa planetaria","2.7 x 1.8 arcmin","5 AL","---","---","---"),
		new messier_cat("M77","Galassia","Balena",2,42,40.78,-0,-0,-47.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","33M AL","Galassia a spirale","7.1 x 6.0 arcmin","68K AL","---","---","---"),
		new messier_cat("M78","Nebulosa Casper","Orione",5,46,46.76,0,0,50.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.3","1.6K AL","Nebulosa diffusa","8 x 6 arcmin","3.7 AL","---","---","---"),
		new messier_cat("M79","Ammasso globulare","Lepre",5,24,10.6,-24,-31,-27.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.73","42K AL","Ammasso globulare","1.3 arcmin","15.9 AL","---","---","---"),
		new messier_cat("M80","Ammasso globulare","Scorpione",16,17,2.42,-22,-58,-33.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.32","33K AL","Ammasso globulare","1.2 arcmin","11.5 AL","---","---","---"),
		new messier_cat("M81","Galassia di Bode","Orsa Maggiore",9,55,33.17,69,3,55.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.9","12M AL","Galassia a spirale","24.9 x 11.5 arcmin","84.6K AL","---","---","---"),
		new messier_cat("M82","Galassia Sigaro","Orsa Maggiore",9,55,52.44,69,40,46.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","12M AL","Galassia a spirale","11.2 x 4.3 arcmin","37.5K AL","---","---","---"),
		new messier_cat("M83","Galassia Girandola del sud","Idra",13,37,0.92,-29,-51,-56.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.5","16M AL","Galassia a spirale","12.9 x 11.5 arcmin","58.8K AL","---","---","---"),
		new messier_cat("M84","Galassia Catena di Markarian","Vergine",12,25,3.75,12,53,13.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.10","60M AL","Galassia ellittica","6.5 x 5.6 arcmin","113.8K AL","---","---","---"),
		new messier_cat("M85","Galassia","Chioma di Berenice",12,25,24.06,18,11,27.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.10","59M AL","Galassia a spirale","7.1 x 5.5 arcmin","120.9K AL","---","---","---"),
		new messier_cat("M86","Galassia Catena di Markarian","Vergine",12,26,11.82,12,56,45.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.89","55M AL","Galassia ellittica","8.9 x 5.8 arcmin","142.1K AL","---","---","---"),
		new messier_cat("M87","Galassia della Vergine","Vergine",12,30,49.43,12,23,28,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.6","55M AL","Galassia ellittica","8.3 x 6.6 arcmin","133.1K AL","---","---","---"),
		new messier_cat("M88","Galassia","Chioma di Berenice",12,31,59.22,14,25,13.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.6","58M AL","Galassia a spirale","6.8 x 3.7 arcmin","114.7K AL","---","---","---"),
		new messier_cat("M89","Galassia","Vergine",12,35,39.89,12,33,21.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.8","52M AL","Galassia ellittica","3.5 x 3.5 arcmin","52.6K AL","---","---","---"),
		new messier_cat("M90","Galassia","Vergine",12,36,49.82,13,9,46.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.5","31M AL","Galassia a spirale","9.5 x 4.4 arcmin","84.9K AL","---","---","---"),
		new messier_cat("M91","Galassia","Chioma di Berenice",12,35,26.44,14,29,46.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10.19","51M AL","Galassia a spirale","5.2 x 4.2 arcmin","77.1K AL","---","---","---"),
		new messier_cat("M92","Ammasso globulare","Ercole",17,17,7.39,43,8,9.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.44","27K AL","Ammasso globulare","2 arcmin","16 AL","---","---","---"),
		new messier_cat("M93","Ammasso aperto Farfalla","Poppa",7,44,30.01,-23,-51,-25.2,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","6.19","3.4K AL","Ammasso aperto","10 arcmin","9.8 AL","---","---","---"),
		new messier_cat("M94","Galassia Occhio di Coccodrillo","Cani da caccia",12,50,53.15,41,7,12.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.19","14M AL","Galassia a spirale","14.4 x 12.1 arcmin","60.5K AL","---","---","---"),
		new messier_cat("M95","Galassia","Leone",10,43,57.74,11,42,13,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.69","31M AL","Galassia a spirale","7.4 x 5.0 arcmin","67.7K AL","---","---","---"),
		new messier_cat("M96","Galassia","Leone",10,46,45.7,11,49,11.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.3","32M AL","Galassia a spirale","7.8 x 5.2 arcmin","73K AL","---","---","---"),
		new messier_cat("M97","Nebulosa Gufo","Orsa Maggiore",11,14,47.7,55,1,8.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.8","1.9K AL","Nebulosa planetaria","3.4 x 3.3 arcmin","1.8 AL","---","---","---"),
		new messier_cat("M98","Galassia","Chioma di Berenice",12,13,48.3,14,54,1.7,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10.1","44M AL","Galassia a spirale","9.8 x 2.8 arcmin","126K AL","---","---","---"),
		new messier_cat("M99","Galassia","Chioma di Berenice",12,18,49.63,14,24,59.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.89","53M AL","Galassia a spirale","5.3 x 4.6 arcmin","81.2K AL","---","---","---"),
		new messier_cat("M100","Galassia Asciugacapelli","Chioma di Berenice",12,22,54.9,15,49,20.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.39","47M AL","Galassia a spirale","7.5 x 6.1 arcmin","101.9K AL","---","---","---"),
		new messier_cat("M101","Galassia Girandola","Orsa Maggiore",14,3,12.59,54,20,55.5,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.9","22M AL","Galassia a spirale","28.8 x 26.9 arcmin","186.4K AL","---","---","---"),
		new messier_cat("M102","Galassia Fuso","Drago",15,6,29.56,55,45,47.9,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.89","48M AL","Galassia a spirale","6.5 x 3.1 arcmin","90.8K AL","---","---","---"),
		new messier_cat("M103","Ammasso aperto","Cassiopea",1,33,23.04,60,39,0,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.4","7.2K AL","Ammasso aperto","5 arcmin","10.4 AL","---","---","---"),
		new messier_cat("M104","Galassia Sombrero","Vergine",12,39,59.44,-11,-37,-23,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.0","29M AL","Galassia a spirale","8.6 x 4.2 arcmin","72.7K AL","---","---","---"),
		new messier_cat("M105","Galassia","Leone",12,18,57.62,47,18,13.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.3","32M AL","Galassia ellittica","5.3 x 4.8 arcmin","49.8K AL","---","---","---"),
		new messier_cat("M106","Galassia","Cani da caccia",12,18,57.62,47,18,13.4,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.39","23M AL","Galassia a spirale","18.6 x 7.2 arcmin","126.7K AL","---","---","---"),
		new messier_cat("M107","Ammasso globulare Crocifisso","Ofiuco",16,32,31.86,-13,-3,-13.6,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","7.92","21K AL","Ammasso globulare","3.5 arcmin","21 AL","---","---","---"),
		new messier_cat("M108","Galassia Tavola da Surf","Orsa Maggiore",11,11,30.97,55,40,26.8,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","10","35M AL","Galassia a spirale","8.6 x 2.4 arcmin","87K AL","---","---","---"),
		new messier_cat("M109","Galassia Aspirapolvere","Orsa Maggiore",11,57,35.99,53,22,28.3,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","9.8","75M AL","Galassia a spirale","7.5 x 4.4 arcmin","163K AL","---","---","---"),
		new messier_cat("M110","Galassia","Andromeda",0,40,22.08,41,41,7.1,0,0,0,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","8.1","2.7M AL","Galassia ellittica","19.5 x 11.5 arcmin","15.4K AL","---","---","---")
		);








		
// FINE DATABASE CATALOGO STELLARE ----------------------------------------------------------		

		// Dichiarazioni delle variabili 	
		giorno = myParseFloat(obj.giorno.value);
		if (giorno >31 | giorno <= 0)
			{
				alert("\n GIORNO ERRATO: \n\n DATI VALIDI DA 1 A 31 \n\n CLICCA SU RESET E RIPROVA"); return; 
			}
		mese = myParseFloat(obj.mese.value);
		if (mese >12 | mese <= 0)
			{
				alert("\n MESE ERRATO: \n\n DATI VALIDI DA 1 A 12 \n\n CLICCA SU RESET E RIPROVA"); return;
			}
		anno = myParseFloat(obj.anno.value);
		
		ore = myParseFloat(obj.ore.value); 
		if (ore >=24 | ore < 0)
			{
				alert("\n ORE ERRATE: \n\n DATI VALIDI DA 0 A 23 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		minuti = myParseFloat(obj.minuti.value); 
		if (minuti >=60 | minuti < 0)
			{
				alert("\n MINUTI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		secondi = myParseFloat(obj.secondi.value); 
		if (secondi >=60 | secondi < 0)
			{
				alert("\n SECONDI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		lat_G = myParseFloat(obj.lat_G.value); 
		if (lat_G >= 90 | lat_G <= -90)
			{
				alert("\n GRADI LATITUDINE ERRATI: \n\n DATI VALIDI DA -89 A +89 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		lat_M = myParseFloat(obj.lat_M.value); 
		if (lat_M >= 60 | lat_M <= -60)
			{
				alert("\n PRIMI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		lat_S = myParseFloat(obj.lat_S.value);
		if (lat_S >= 60 | lat_S <= -60)
			{
				alert("\n SECONDI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		long_G = myParseFloat(obj.long_G.value); 
		if (long_G >= 180 | long_G <= -180)
			{
				alert("\n GRADI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -179 A +179 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		long_M = myParseFloat(obj.long_M.value); 
		if (long_M >= 60 | long_M <= -60)
			{
				alert("\n PRIMI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
		long_S = myParseFloat(obj.long_S.value); 
		if (long_S >= 60 | long_S <= -60)
			{
				alert("\n SECONDI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA"); 
			}
			
		pressione = myParseFloat(obj.PRESSIONE.value); 
		if (pressione >=1300 | pressione <= 300)
			{
				alert("\n DATO PRESSIONE INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
			}	
			

		temperatura = myParseFloat(obj.TEMPERATURA.value); 
		if (temperatura >=100 | temperatura <= -50)
			{
				alert("\n DATO TEMPERATURA INSERITO ANOMALO \n\n CLICCA SU RESET E RIPROVA"); 
			}	
			
		metri = myParseFloat(obj.METRI.value); 	
		
		
		fuso = myParseFloat(obj.FUSO_ORARIO.value); 	
		
	
		
		

		for (var i=0; i<messier.length; i++) 
			{
						
						
			// Creazione delle variabili fisse prese dal catalogo (dati AR e DEC del 2000)
			// ore ascensione retta 	
			astro_h = messier[i].ra_h;
			// minuti ascensione retta 	
			astro_m = messier[i].ra_m;
			// secondi ascensione retta 	
			astro_s = messier[i].ra_s;
			// gradi declinazione 	
			astro_g = messier[i].de_g;
			// primi declinazione 	
			astro_p = messier[i].de_p;
			// secondi declinazione 	
			astro_ss = messier[i].de_ss;
			// ore moto proprio ascensione retta 	
			astro_mph = messier[i].mpra_h;
			// minuti moto proprio ascensione retta 
			astro_mpm = messier[i].mpra_m;
			// secondi moto proprio ascensione retta 	
			astro_mps = messier[i].mpra_s;
			// gradi moto proprio declinazione 	
			astro_mpg = messier[i].mpde_g;
			// primi moto proprio declinazione 
			astro_mpp = messier[i].mpde_p;
			// secondi moto proprio declinazione 	
			astro_mpss = messier[i].mpde_ss;
				
			// Conversione Dati di Astro del 1950 in gradi decimali sessagesimali  
			astro_ra = (astro_s / 3600 + astro_m / 60 + astro_h) * 15; 
			astro_dec = astro_ss / 3600 + astro_p / 60 + astro_g; 
			astro_mpra = (astro_mps / 3600 + astro_mpm / 60 + astro_mph)  * 15; 
			astro_mpdec = astro_mpss / 3600 + astro_mpp / 60 + astro_mpg; 
		
			// Prepara l'oggetto giorno e mese inferiori a 10 con lo zero davanti al numero per il confronto con il 15821015
			if (obj.giorno.value < 10) {obj.giorno.value = "0"+obj.giorno.value};
			if (obj.mese.value < 10) {obj.mese.value = "0"+obj.mese.value};
	
			// Unisce anno mese giorno in una stringa 
			s = (obj.anno.value+obj.mese.value+obj.giorno.value);
	
			// La stringa data unita ritorna numero 
			s = parseInt(s);  	
			
			// Toglie gli zeri al giorno creati con la ripetizione dei calcoli 
			obj.giorno.value = giorno; 
			// Toglie gli zeri al mese creati con la ripetizione dei calcoli 
			obj.mese.value = mese;
	
			// Calcolo dei giorni e ore decimali
			giorno_dec = (secondi / 3600 + minuti / 60 + ore)/24 + giorno;
			ore_dec = secondi / 3600 + minuti /60 + ore;
	
			// Return da funzione jd_ore_0 contenuta in jd_ore_0.js  
			// Creazione variabile JD_0  
			JD_0 = jd_ore_0();
	 				
			// Return da funzione jd_ore_ut contenuta in jd_ore_ut.js
			// Creazione variabile JD_UT   
			JD_UT = jd_ore_ut(); 
						
			// Scrive i risultati nel catalogo presi dai calcoli delle funzioni contenute in: asc_dec.js - alt_az.js - coord_ecl.js 
			// ascensione retta 
			messier[i].ra_h1 = ascdec()[34];
			messier[i].ra_m1 = ascdec()[35];
			messier[i].ra_s1 = ascdec()[36].toFixed(2);
			// declinazione 
			messier[i].sgn_dec = ascdec()[40];
			messier[i].de_g1 = ascdec()[37];
			messier[i].de_p1 = ascdec()[38];
			messier[i].de_ss1 = ascdec()[39].toFixed(2);
			// atezza 
			messier[i].altezza = altaz()[9];
			messier[i].azimut = altaz()[10];
			messier[i].sgn_h = altaz()[8];
			messier[i].h_g = altaz()[2];
			messier[i].h_p = altaz()[3];
			messier[i].h_ss = altaz()[4].toFixed(2);
			// azimut 
			messier[i].a_g = altaz()[5];
			messier[i].a_p = altaz()[6];
			messier[i].a_ss = altaz()[7].toFixed(2);
			// latitudine ecclittica 
			messier[i].sgn_e = coecl()[6];
			messier[i].laec_g = coecl()[0];
			messier[i].laec_p = coecl()[1];
			messier[i].laec_ss = coecl()[2].toFixed(2);
			// longitudine ecclittica
			messier[i].loec_g = coecl()[3];
			messier[i].loec_p = coecl()[4];
			messier[i].loec_ss = coecl()[5].toFixed(2);
					
			}
		


				
			// VARIABILI PER LE CONVERSIONI GRADI RADIANTI E VICEVERSA 
			var d2r = Math.PI / 180; 
			var r2d = 180 / Math.PI;
			
			// DISEGNA LO STARFINDER  -----------------------------------------------------------------------------------
			// PRENDE IL CANVAS DALLA PAGINA WEB 
			var canvas = document.getElementById('myCanvas_2');
			// DEFINISCE LA CARATTERISTICA 2D DEL CANVAS 
		  	var context = canvas.getContext('2d');
			// PULISCE TUTTO IL CANVAS  
			context.clearRect(0, 0, canvas.width, canvas.height);
			// VARIABILI GENERALI PER LA SCALA  E LA DISTANZA DEL TESTO 
			var x_scale = 1;
			var y_scale = 1;
			var dist_testo = 2;
			// VARIABILI GENERALI PER LE COORDINATE DEL CENTRO 
		  	var centerX = canvas.width / x_scale / 2;
		  	var centerY = canvas.height / y_scale / 2;
			// VARIABILE GENERALE COLORE DEGLI OGGETTI MESSIER 
			var messier_color = '#00F';	
			// VARIABILE GENERALE COLORE NOMI DEGLI OGGETTI MESSIER 
			var name_messier_color = '#FF0000';
			// VARIABILE GENERALE FONT NOMI DEGLI OGGETTI MESSIER 
			var name_messier_font = "10px Arial";	
			// VARIABILE GENERALE COLORE NOMI DEGLI OGGETTI MESSIER 
			var name_const_color = '#FFF000';	
			// VARIABILE GENERALE FONT NOMI DEGLI OGGETTI MESSIER 
			var name_const_font = "10px Arial";	
			
			// OPZIONE VISUALIZZAZIONE MESSIER (SI) ------------------------------------------------------------------------
			var messier_si = 0;
			var messier_no = 1;
			if (obj.scelta_messier[messier_si].checked){var scelta_messier = 0;}
			if (obj.scelta_messier[messier_no].checked){var scelta_messier = 1;}
			if (scelta_messier == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0)
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA GLI OGGETTI MESSIER SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE DI TUTTI GLI OGGETTI MESSIER
				
				
				
			// OPZIONE VISUALIZZAZIONE GALASSIE A SPIRALE (SI) ------------------------------------------------------------------------
			var galassie_spirale_si = 0;
			var galassie_spirale_no = 1;
			if (obj.scelta_galassie_spirale[galassie_spirale_si].checked){var scelta_galassie_spirale = 0;}
			if (obj.scelta_galassie_spirale[galassie_spirale_no].checked){var scelta_galassie_spirale = 1;}
			if (scelta_galassie_spirale == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0 && messier[i].type == "Galassia a spirale")
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA SOLO LE GALASSIE A SPIRALE SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE GALASSIE A SPIRALE
				
				
			// OPZIONE VISUALIZZAZIONE GALASSIE ELLITTICHE (SI) ------------------------------------------------------------------------
			var galassie_ellittiche_si = 0;
			var galassie_ellittiche_no = 1;
			if (obj.scelta_galassie_ellittiche[galassie_ellittiche_si].checked){var scelta_galassie_ellittiche = 0;}
			if (obj.scelta_galassie_ellittiche[galassie_ellittiche_no].checked){var scelta_galassie_ellittiche = 1;}
			if (scelta_galassie_ellittiche == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0 && messier[i].type == "Galassia ellittica")
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA SOLO LE GALASSIE ELLITTICHE SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE GALASSIE ELLITTICHE 
		
		
			// OPZIONE VISUALIZZAZIONE NEBULOSE PLANETARIE (SI) ------------------------------------------------------------------------
			var nebulose_planetarie_si = 0;
			var nebulose_planetarie_no = 1;
			if (obj.scelta_nebulose_planetarie[nebulose_planetarie_si].checked){var scelta_nebulose_planetarie = 0;}
			if (obj.scelta_nebulose_planetarie[nebulose_planetarie_no].checked){var scelta_nebulose_planetarie = 1;}
			if (scelta_nebulose_planetarie == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0 && messier[i].type == "Nebulosa planetaria")
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA SOLO LE NEBULOSE PLANETARIE SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE NEBULOSE PLANETARIE
		
		
			// OPZIONE VISUALIZZAZIONE NEBULOSE DIFFUSE (SI) ------------------------------------------------------------------------
			var nebulose_diffuse_si = 0;
			var nebulose_diffuse_no = 1;
			if (obj.scelta_nebulose_diffuse[nebulose_diffuse_si].checked){var scelta_nebulose_diffuse = 0;}
			if (obj.scelta_nebulose_diffuse[nebulose_diffuse_no].checked){var scelta_nebulose_diffuse = 1;}
			if (scelta_nebulose_diffuse == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0 && messier[i].type == "Nebulosa diffusa")
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA SOLO LE NEBULOSE DIFFUSE SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE NEBULOSE DIFFUSE
				
				
				
			// OPZIONE VISUALIZZAZIONE AMMASSI GLOBULARI (SI) ------------------------------------------------------------------------
			var ammassi_globulari_si = 0;
			var ammassi_globulari_no = 1;
			if (obj.scelta_ammassi_globulari[ammassi_globulari_si].checked){var scelta_ammassi_globulari = 0;}
			if (obj.scelta_ammassi_globulari[ammassi_globulari_no].checked){var scelta_ammassi_globulari = 1;}
			if (scelta_ammassi_globulari == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0 && messier[i].type == "Ammasso globulare")
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA SOLO AMMASSI GLOBULARI SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE AMMASSI GLOBULARI
				
				
	
	
	
	
	
	
	
	
			// OPZIONE VISUALIZZAZIONE AMMASSI APERTI (SI) ------------------------------------------------------------------------
			var ammassi_aperti_si = 0;
			var ammassi_aperti_no = 1;
			if (obj.scelta_ammassi_aperti[ammassi_aperti_si].checked){var scelta_ammassi_aperti = 0;}
			if (obj.scelta_ammassi_aperti[ammassi_aperti_no].checked){var scelta_ammassi_aperti = 1;}
			if (scelta_ammassi_aperti == 0) 
	 			{
					// CICLO FOR - NEXT CHE FORNISCE I RISULTATI DELLE STELLE 
					for (var i=0; i<messier.length; i++) 
					{		
						// VARIABILI PER LA SCALA  E LA DISTANZA DEL TESTO 
						var dist_testo = 2;
						// COORDINATE DEL CENTRO 
					  	var centerX = canvas.width / x_scale / 2;
					  	var centerY = canvas.height / y_scale / 2;
						// DEFINISCE ALTEZZA ED AZIMUT DEL CICLO FOR NEXT CHE CALCOLA LE ALTEZZE E GLI AZIMUT DELLE STELLE
						var h_graph = messier[i].altezza; 
						var az_graph = messier[i].azimut;
						// CONVERSIONE ALTEZZA ED AZIMUT IN COORDINATE X Y 
						var zh = (90 - h_graph) * 350 / 90; 
						var x = zh * Math.sin(az_graph * d2r) ; 
						var y = zh * Math.cos(az_graph * d2r) ;
						// DEFINISCE IL RAGGIO CHE DEVE AVERE L'OGGETTO 
						radius = 3;
						// DEFINISCE IL COLORE DELL'OGGETTO 
						if(messier[i].type == "Ammasso globulare"){messier_color = '#FFF'}
						if(messier[i].type == "Ammasso aperto"){messier_color = '#FF0'}
						if(messier[i].type == "Nebulosa diffusa"){messier_color = '#00F'}
						if(messier[i].type == "Nebulosa planetaria"){messier_color = '#3FF'}
						if(messier[i].type == "Galassia"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia a spirale"){messier_color = '#3F0'}
						if(messier[i].type == "Galassia ellittica"){messier_color = '#3F0'}
											
			
						// CONDIZIONE CHE VISUALIZZA SOLO LE STELLE SOPRA L'ORIZZONTE ASTRONOMICO 
						if (messier[i].altezza > 0 && messier[i].type == "Ammasso aperto")
						{
			
      					// INIZIO PERCORSO GRAFICO 
						context.beginPath();	
								// DEFINISCE L'ARCO CHE CREA IL CERCHIETTO DELLA STELLA
     			 				context.arc(centerX + x*-1, centerY + y*-1, radius, 0, 2 * Math.PI, false);
								// DEFINISCE IL COLORE DELL'ARCO
		 			   			context.fillStyle = messier_color;
								// RIEMPIMENTO DELL'ARCO 
      							context.fill();
								
								
								context.beginPath();	
								context.fillStyle = name_messier_color;
								context.fill();
								context.font = name_messier_font;
								context.fillText(messier[i].catnum,centerX + x*-1 + dist_testo, centerY + y*-1 - dist_testo);
								
								
						
						}  // FINE DELLA CONDIZIONE CHE VISUALIZZA SOLO AMMASSI APERTI SOPRA L'ORIZZONTE 
					
					}  // FINE DEL CICLO FOR NEXT 
				}  // FINE DELLA OPZIONE VISUALIZZAZIONE AMMASSI APERTI
				
				
				
				
				
				
				
			// OPZIONE LINEE ALMICANTARAT E AZIMUT (SI) ----------------------------------------------------------------  
			var linea_messier_si = 0;
			var linea_messier_no = 1;
			if (obj.scelta_linea_messier[linea_messier_si].checked){var scelta_linea_messier = 0;}
			if (obj.scelta_linea_messier[linea_messier_no].checked){var scelta_linea_messier = 1;}
			if (scelta_linea_messier == 0) 
	 			{
					// DEFINISCE IL TIPO DI LINEA 
					context.setLineDash([0.5, 0.5]);
					context.lineWidth=1;						
					// CICLO FOR-NEXT CHE DISEGNA GLI ALMICANTARAT 
					for (var i=10; i<90 ; i +=10) 
					{			
	      				context.beginPath();
      					context.arc(centerX , centerY , (90-i)*350/90, 0, 2 * Math.PI, false);
						context.strokeStyle = '#FF0000';
      					context.stroke();
		    			context.fillStyle = '#FFF000';
						context.font = "10px Arial";			
						context.fillText(i,centerX + dist_testo, centerY + (90-i)*350/90 - dist_testo );
					}
			
					//CICLO FOR-NEXT CHE DISEGNA GLI AZIMUT DA 10 A 80
					for (var i=10; i<90 ; i +=10) 
					{
						context.beginPath();
						context.moveTo(centerX  , centerY);
						var h_az = 0; 
						var az_az = i;
						var zh = (90 - h_az) * 350 / 90; 
						var x = zh * Math.sin(az_az * d2r) ; 
						var y = zh * Math.cos(az_az * d2r) ;
      					context.lineTo(centerX + x*-1, centerY + y*-1);
						context.strokeStyle = '#FF0000';
      					context.stroke();
						context.fillStyle = '#FFF000';
						context.font = "10px Arial";			
						context.fillText(i,centerX - 12  + x*-1, centerY - 2 + y*-1);
					}
					//CICLO FOR-NEXT CHE DISEGNA GLI AZIMUT DA 100 A 170
					for (var i=100; i<180 ; i +=10) 
					{
						context.beginPath();
						context.moveTo(centerX  , centerY);
						var h_az = 0; 
						var az_az = i;
						var zh = (90 - h_az) * 350 / 90; 
						var x = zh * Math.sin(az_az * d2r) ; 
						var y = zh * Math.cos(az_az * d2r) ;
      					context.lineTo(centerX + x*-1, centerY + y*-1);
						context.strokeStyle = '#FF0000';
      					context.stroke();
						context.fillStyle = '#FFF000';
						context.font = "10px Arial";			
						context.fillText(i,centerX - 20  + x*-1, centerY + 10 + y*-1);
					}
					//CICLO FOR-NEXT CHE DISEGNA GLI AZIMUT DA 190 A 260
					for (var i=190; i<270 ; i +=10) 
					{
						context.beginPath();
						context.moveTo(centerX  , centerY);
						var h_az = 0; 
						var az_az = i;
						var zh = (90 - h_az) * 350 / 90; 
						var x = zh * Math.sin(az_az * d2r) ; 
						var y = zh * Math.cos(az_az * d2r) ;
      					context.lineTo(centerX + x*-1, centerY + y*-1);
						context.strokeStyle = '#FF0000';
      					context.stroke();
						context.fillStyle = '#FFF000';
						context.font = "10px Arial";			
						context.fillText(i,centerX + 2  + x*-1, centerY + 10 + y*-1);
					}
					//CICLO FOR-NEXT CHE DISEGNA GLI AZIMUT DA 280 A 350
					for (var i=280; i<360 ; i +=10) 
					{
						context.beginPath();
						context.moveTo(centerX  , centerY);
						var h_az = 0; 
						var az_az = i;
						var zh = (90 - h_az) * 350 / 90; 
						var x = zh * Math.sin(az_az * d2r) ; 
						var y = zh * Math.cos(az_az * d2r) ;
      					context.lineTo(centerX + x*-1, centerY + y*-1);
						context.strokeStyle = '#FF0000';
      					context.stroke();
						context.fillStyle = '#FFF000';
						context.font = "10px Arial";			
						context.fillText(i,centerX + 2  + x*-1, centerY - 2 + y*-1);
					}
				}
				
				
				
			
				

 			// INIZIA UN NUOVO PERCORSO GRAFICO CHE DEFINISCE LE LINEE FISSE -----------------------------------------
	      	context.beginPath();
			// CERCHIO DELL'ORIZZONTE 
      		context.arc(centerX , centerY , 350, 0, 2 * Math.PI, false);
			// DEFINISCE ILTIPO DI LINEA 
			context.setLineDash([0.5, 0.5]);
			context.lineWidth=1;						
			// LINEA EST - OVEST 
			context.moveTo(centerX - 350 , centerY);
      		context.lineTo(750 , centerY);
			// LINEA NORD - SUD 
			context.moveTo(centerX  , centerY - 350);
      		context.lineTo(centerX , 750);
			// context.moveTo(centerX  , centerY);
				
			// DISEGNA LE LINEE 
      		context.strokeStyle = '#FF0000';
      		context.stroke();



			// DISEGNA IL TESTO DEI PUNTI CARDINALI E LO ZENIT 
			// COLORE DEI PUNTI CARDINALI 
			context.fillStyle = '#FFF000';
			context.font = "12px Arial";
			context.fillText("Nord",centerX - 15 , centerY - 355);
			context.fillText("Sud",centerX - 12 , centerY + 365);
			context.fillText("Est",centerX - 375 , centerY + 4 );
			context.fillText("Ovest",centerX + 355 , centerY + 4 );
			context.fillText("Zenit",centerX + 5, centerY - 2 );
			
			
					
			//context.translate(400 , 400);
			// context.scale (0.5 , 0.5);
			// context.rotate (0);
	
// FUNZIONE CHE VISUALIZZA SUL GRAFICO LE COORDINATE X Y 
   function writeMessage(canvas, message) {
        var context = canvas.getContext('2d');
        context.clearRect(0, 0, 350, 20);
        context.font = '12pt Calibri';
        context.fillStyle = 'white';
        context.fillText(message, 12, 12);
      }
      function getMousePos(canvas, evt) {
        var rect = canvas.getBoundingClientRect();

        return {
         x: evt.clientX  - rect.left - 400 ,
         y: evt.clientY - rect.top - 400
        };
      }
      var canvas = document.getElementById('myCanvas_2');
      var context = canvas.getContext('2d');

canvas.addEventListener('mousemove', function(evt) {
        var mousePos = getMousePos(canvas, evt);
		
        var x_1 = getMousePos(canvas, evt);
		var y_1 = getMousePos(canvas, evt);
		var zh_1_pix = Math.sqrt(Math.pow(x_1.x*-1,2) + Math.pow(y_1.y*-1,2)); 
		var zh_1_gradi = zh_1_pix / 350 * 90; 
		var h_1 = 90 - zh_1_gradi; 
		var az_1 = Math.asin(x_1.x*-1 / zh_1_pix) * r2d;  
		// CONDIZIONI CHE SISTEMANO I QUADRANTI 
		if(az_1 < 0){az_1 = az_1 + 360}
		if(x_1.x > 0 && y_1.y > 0){az_1 = 360 - az_1 + 180}
		if(x_1.x < 0 && y_1.y > 0){az_1 = az_1*-1 + 180}
        var message = "             Coord." + "   Alt. " + h_1.toFixed(1)  + "°" +  "   Az. " + az_1.toFixed(1) + "°";
        writeMessage(canvas, message);
      }, false);


		}
	else 
		{
			alert("ERRORE\n\nHAI TENTATO DI MODIFICARE LA PAGINA WEB\n\nSPIACENTE IL PROGRAMMA NON FUNZIONERA' PIU'"); 
		}		
}
